<?php
// controllers/DashboardController.php

require_once 'BaseController.php';

class DashboardController extends BaseController {
    private $ventaModel;

    public function __construct() {
        // Asumimos que el autoloader ya ha cargado Venta.php
        $this->ventaModel = new Venta();
    }

    public function index() {
        $anioActual = date('Y');
        
        // Obtener datos del modelo
        $estadisticas = $this->ventaModel->getEstadisticasGenerales();
        $ventasDiarias = $this->ventaModel->getVentasUltimosDias(15); // Últimos 15 días
        $ventasMensuales = $this->ventaModel->getVentasMensuales($anioActual);
        $ventasAnuales = $this->ventaModel->getVentasAnuales();

        // --- Preparar datos para los gráficos ---

        // Gráfico de ventas diarias
        $labelsDiario = [];
        $dataDiario = [];
        foreach ($ventasDiarias as $venta) {
            $labelsDiario[] = date('d/m', strtotime($venta['dia']));
            $dataDiario[] = $venta['total_dia'];
        }

        // Gráfico de ventas mensuales
        $labelsMensual = [];
        $dataMensual = array_fill(0, 12, 0); // Array de 12 meses inicializado en 0
        $mesesNombres = ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"];
        foreach ($ventasMensuales as $venta) {
            $mesIndex = $venta['mes'] - 1;
            $dataMensual[$mesIndex] = $venta['total_mes'];
        }
        $labelsMensual = $mesesNombres;

        // Gráfico de ventas anuales
        $labelsAnual = [];
        $dataAnual = [];
        foreach ($ventasAnuales as $venta) {
            $labelsAnual[] = $venta['anio'];
            $dataAnual[] = $venta['total_anio'];
        }
        
        // Pasar datos a la vista
        $this->view('dashboard/index', [
            'title' => 'Dashboard de Ventas',
            'estadisticas' => $estadisticas,
            'chartData' => [
                'diario' => ['labels' => $labelsDiario, 'data' => $dataDiario],
                'mensual' => ['labels' => $labelsMensual, 'data' => $dataMensual, 'anio' => $anioActual],
                'anual' => ['labels' => $labelsAnual, 'data' => $dataAnual]
            ]
        ]);
    }
}
