<?php
// controllers/ReporteController.php

require_once 'BaseController.php';

class ReporteController extends BaseController {
    private $ventaModel;
    private $clienteModel;
    private $productoModel;

    public function __construct() {
        $this->ventaModel = new Venta();
        $this->clienteModel = new Cliente();
        $this->productoModel = new Producto();
    }

    // Reporte de Ventas con filtro por fechas
    public function ventas() {
        $fecha_inicio = date('Y-m-01'); // Primer día del mes actual por defecto
        $fecha_fin = date('Y-m-t'); // Último día del mes actual por defecto

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $fecha_inicio = $_POST['fecha_inicio'];
            $fecha_fin = $_POST['fecha_fin'];
        }
        
        // Ajustar fecha fin para que incluya todo el día
        $fecha_fin_ajustada = $fecha_fin . ' 23:59:59';

        $ventas = $this->ventaModel->getVentasPorFechas($fecha_inicio, $fecha_fin_ajustada);

        $this->view('reportes/ventas', [
            'ventas' => $ventas,
            'fecha_inicio' => $fecha_inicio,
            'fecha_fin' => $fecha_fin,
            'title' => 'Reporte de Ventas'
        ]);
    }

    // Reporte de Clientes
    public function clientes() {
        $clientes = $this->clienteModel->getAll();
        $this->view('reportes/clientes', [
            'clientes' => $clientes,
            'title' => 'Reporte de Clientes'
        ]);
    }

    // Reporte de Productos
    public function productos() {
        $productos = $this->productoModel->getAll();
        $this->view('reportes/productos', [
            'productos' => $productos,
            'title' => 'Reporte de Productos y Stock'
        ]);
    }
}
