<?php
// Front-Controller

// Cargar configuración
require_once '../config/database.php';

// Autoloader para clases de Modelos y Controladores
spl_autoload_register(function ($className) {
    $modelPath = '../models/' . $className . '.php';
    $controllerPath = '../controllers/' . $className . '.php';

    if (file_exists($modelPath)) {
        require_once $modelPath;
    } elseif (file_exists($controllerPath)) {
        require_once $controllerPath;
    }
});

// Parsear la URL para determinar el controlador y la acción
$controllerName = isset($_GET['controller']) ? ucfirst($_GET['controller']) . 'Controller' : 'HomeController';
$actionName = isset($_GET['action']) ? $_GET['action'] : 'index';

// Verificar si el controlador existe
if (class_exists($controllerName)) {
    $controller = new $controllerName();

    // Verificar si la acción existe en el controlador
    if (method_exists($controller, $actionName)) {
        // Llamar a la acción
        $controller->$actionName();
    } else {
        // Error: Acción no encontrada
        echo "Error 404: Acción no encontrada.";
    }
} else {
    // Error: Controlador no encontrado
    echo "Error 404: Controlador no encontrado.";
}
