<!-- Incluir Chart.js desde CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<div class="container-fluid">
    <h1 class="mb-4"><?php echo $title; ?></h1>

    <!-- Fila de Tarjetas de Resumen -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Ventas (Hoy)</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">$<?php echo number_format($estadisticas['hoy'] ?? 0, 2); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-calendar-day fs-2 text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Ventas (Este Mes)</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">$<?php echo number_format($estadisticas['mes'] ?? 0, 2); ?></div>
                        </div>
                        <div class="col-auto">
                             <i class="bi bi-calendar-month fs-2 text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Ventas (Este Año)</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">$<?php echo number_format($estadisticas['anio'] ?? 0, 2); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-calendar-event fs-2 text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Ventas (Total Histórico)</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">$<?php echo number_format($estadisticas['total_historico'] ?? 0, 2); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-clock-history fs-2 text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Fila de Gráficos -->
    <div class="row">
        <!-- Gráfico de Ventas Diarias -->
        <div class="col-lg-7 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Ventas de los Últimos 15 Días</h6>
                </div>
                <div class="card-body">
                    <canvas id="ventasDiariasChart"></canvas>
                </div>
            </div>
        </div>
        <!-- Gráfico de Ventas Mensuales -->
        <div class="col-lg-5 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Ventas Mensuales (Año <?php echo $chartData['mensual']['anio']; ?>)</h6>
                </div>
                <div class="card-body">
                    <canvas id="ventasMensualesChart"></canvas>
                </div>
            </div>
        </div>
    </div>
     <div class="row">
        <!-- Gráfico de Ventas Anuales -->
        <div class="col-lg-12 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Resumen de Ventas Anuales</h6>
                </div>
                <div class="card-body">
                    <canvas id="ventasAnualesChart"></canvas>
                </div>
            </div>
        </div>
    </div>

</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    // --- Gráfico de Ventas Diarias ---
    const ctxDiario = document.getElementById('ventasDiariasChart').getContext('2d');
    new Chart(ctxDiario, {
        type: 'line',
        data: {
            labels: <?php echo json_encode($chartData['diario']['labels']); ?>,
            datasets: [{
                label: 'Ventas ($)',
                data: <?php echo json_encode($chartData['diario']['data']); ?>,
                backgroundColor: 'rgba(78, 115, 223, 0.05)',
                borderColor: 'rgba(78, 115, 223, 1)',
                borderWidth: 2,
                pointRadius: 3,
                pointBackgroundColor: 'rgba(78, 115, 223, 1)',
                fill: true,
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) { return '$' + value; }
                    }
                }
            }
        }
    });

    // --- Gráfico de Ventas Mensuales ---
    const ctxMensual = document.getElementById('ventasMensualesChart').getContext('2d');
    new Chart(ctxMensual, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($chartData['mensual']['labels']); ?>,
            datasets: [{
                label: 'Ventas ($)',
                data: <?php echo json_encode($chartData['mensual']['data']); ?>,
                backgroundColor: 'rgba(28, 200, 138, 0.8)',
                borderColor: 'rgba(28, 200, 138, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) { return '$' + value; }
                    }
                }
            }
        }
    });

    // --- Gráfico de Ventas Anuales ---
    const ctxAnual = document.getElementById('ventasAnualesChart').getContext('2d');
    new Chart(ctxAnual, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($chartData['anual']['labels']); ?>,
            datasets: [{
                label: 'Ventas ($)',
                data: <?php echo json_encode($chartData['anual']['data']); ?>,
                backgroundColor: 'rgba(54, 185, 204, 0.8)',
                borderColor: 'rgba(54, 185, 204, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) { return '$' + value; }
                    }
                }
            }
        }
    });
});
</script>

<!-- Estilos adicionales para las tarjetas de resumen -->
<style>
.card .border-left-primary { border-left: .25rem solid #4e73df !important; }
.card .border-left-success { border-left: .25rem solid #1cc88a !important; }
.card .border-left-info { border-left: .25rem solid #36b9cc !important; }
.card .border-left-warning { border-left: .25rem solid #f6c23e !important; }
.text-gray-300 { color: #dddfeb !important; }
</style>
