<div class="card">
    <div class="card-header">
        <h2>Editar Producto</h2>
    </div>
    <div class="card-body">
        <form action="index.php?controller=producto&action=update" method="POST">
            <input type="hidden" name="id" value="<?php echo htmlspecialchars($producto['id']); ?>">
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="codigo" class="form-label">Código</label>
                    <input type="text" class="form-control" id="codigo" name="codigo" value="<?php echo htmlspecialchars($producto['codigo']); ?>">
                </div>
                <div class="col-md-6 mb-3">
                    <label for="nombre" class="form-label">Nombre del Producto</label>
                    <input type="text" class="form-control" id="nombre" name="nombre" value="<?php echo htmlspecialchars($producto['nombre']); ?>" required>
                </div>
            </div>
            <div class="mb-3">
                <label for="descripcion" class="form-label">Descripción</label>
                <textarea class="form-control" id="descripcion" name="descripcion" rows="3"><?php echo htmlspecialchars($producto['descripcion']); ?></textarea>
            </div>
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label for="precio_venta" class="form-label">Precio de Venta</label>
                    <div class="input-group">
                        <span class="input-group-text">$</span>
                        <input type="number" class="form-control" id="precio_venta" name="precio_venta" step="0.01" value="<?php echo htmlspecialchars($producto['precio_venta']); ?>" required>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <label for="precio_compra" class="form-label">Precio de Compra</label>
                    <div class="input-group">
                        <span class="input-group-text">$</span>
                        <input type="number" class="form-control" id="precio_compra" name="precio_compra" step="0.01" value="<?php echo htmlspecialchars($producto['precio_compra']); ?>" required>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <label for="stock" class="form-label">Stock / Inventario</label>
                    <input type="number" class="form-control" id="stock" name="stock" step="0.01" value="<?php echo htmlspecialchars($producto['stock']); ?>" required>
                </div>
            </div>
            
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-arrow-repeat"></i> Actualizar Producto
            </button>
            <a href="index.php?controller=producto&action=index" class="btn btn-secondary">
                <i class="bi bi-x-circle-fill"></i> Cancelar
            </a>
        </form>
    </div>
</div>
