<form action="index.php?controller=venta&action=store" method="POST" id="form-venta">
    <div class="card">
        <div class="card-header">
            <h2>Nueva Nota de Venta</h2>
        </div>
        <div class="card-body">
            <!-- Fila para Cliente y Fecha -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <label for="cliente" class="form-label"><b>Cliente:</b></label>
                    <select id="cliente" name="id_cliente" class="form-select" required>
                        <option value="">Seleccione un cliente...</option>
                        <?php foreach ($clientes as $cliente): ?>
                            <option value="<?php echo $cliente['id']; ?>"><?php echo htmlspecialchars($cliente['nombre']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label"><b>Fecha:</b></label>
                    <p><?php echo date('d/m/Y H:i:s'); ?></p>
                </div>
            </div>

            <!-- Fila para agregar productos -->
            <div class="row mb-3 border-top pt-3">
                <div class="col-md-5">
                    <label for="producto-select" class="form-label">Producto:</label>
                    <select id="producto-select" class="form-select">
                        <option value="">Seleccione un producto...</option>
                        <?php foreach ($productos as $producto): ?>
                            <option value="<?php echo $producto['id']; ?>" data-precio="<?php echo $producto['precio_venta']; ?>" data-stock="<?php echo $producto['stock']; ?>">
                                <?php echo htmlspecialchars($producto['nombre']) . " (Stock: " . $producto['stock'] . ")"; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="cantidad-add" class="form-label">Cantidad:</label>
                    <input type="number" id="cantidad-add" class="form-control" value="1" min="0.01" step="0.01">
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button type="button" id="btn-agregar-producto" class="btn btn-primary">
                        <i class="bi bi-plus-circle"></i> Agregar
                    </button>
                </div>
            </div>
            
            <!-- Tabla con los productos de la venta -->
            <h4 class="mt-4">Detalle de la Venta</h4>
            <div class="table-responsive">
                <table id="tabla-detalles" class="table table-bordered">
                    <thead class="table-dark">
                        <tr>
                            <th>Producto</th>
                            <th width="15%">Cantidad</th>
                            <th width="15%">Precio Unit.</th>
                            <th width="15%">Subtotal</th>
                            <th width="10%">Acción</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Filas de productos agregados dinámicamente -->
                    </tbody>
                </table>
            </div>

            <!-- Total de la Venta -->
            <div class="row justify-content-end mt-3">
                <div class="col-md-4">
                    <div class="d-flex justify-content-between">
                        <h4>Total:</h4>
                        <h4 id="total-venta-display">$0.00</h4>
                    </div>
                </div>
            </div>

            <!-- Inputs ocultos para enviar datos al controller -->
            <input type="hidden" name="total_venta" id="total_venta_input" value="0">
            <input type="hidden" name="productos" id="productos_input" value="[]">

        </div>
        <div class="card-footer text-end">
            <button type="submit" class="btn btn-success btn-lg">
                <i class="bi bi-cash-stack"></i> Finalizar Venta
            </button>
            <a href="index.php" class="btn btn-danger btn-lg">
                <i class="bi bi-x-circle"></i> Cancelar Venta
            </a>
        </div>
    </div>
</form>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const btnAgregar = document.getElementById('btn-agregar-producto');
    const productoSelect = document.getElementById('producto-select');
    const cantidadInput = document.getElementById('cantidad-add');
    const tablaDetallesBody = document.querySelector('#tabla-detalles tbody');
    const totalDisplay = document.getElementById('total-venta-display');
    const form = document.getElementById('form-venta');
    
    // Inputs ocultos
    const totalVentaInput = document.getElementById('total_venta_input');
    const productosInput = document.getElementById('productos_input');

    let productosEnVenta = [];

    btnAgregar.addEventListener('click', function () {
        const selectedOption = productoSelect.options[productoSelect.selectedIndex];
        if (!selectedOption.value) return;

        const productoId = selectedOption.value;
        const productoNombre = selectedOption.text.split(' (Stock:')[0];
        const precio = parseFloat(selectedOption.dataset.precio);
        const stockDisponible = parseFloat(selectedOption.dataset.stock); // Ahora stock puede ser decimal
        const cantidad = parseFloat(cantidadInput.value); // Ahora cantidad puede ser decimal

        if (cantidad <= 0) {
            alert('La cantidad debe ser mayor a cero.');
            return;
        }

        if (cantidad > stockDisponible) {
            alert(`Stock insuficiente. Solo quedan ${stockDisponible.toFixed(2)} unidades de ${productoNombre}.`);
            return;
        }

        const productoExistente = productosEnVenta.find(p => p.id === productoId);
        if (productoExistente) {
             alert('El producto ya ha sido agregado. Puede modificar la cantidad directamente en la tabla.');
             return;
        }

        productosEnVenta.push({
            id: productoId,
            nombre: productoNombre,
            cantidad: cantidad,
            precio: precio,
            stock: stockDisponible // Mantener stock para validación posterior
        });

        actualizarTablaYTotal();
        productoSelect.value = '';
        cantidadInput.value = '1';
    });

    function actualizarTablaYTotal() {
        tablaDetallesBody.innerHTML = '';
        let totalGeneral = 0;

        productosEnVenta.forEach(producto => {
            const subtotal = producto.cantidad * producto.precio;
            totalGeneral += subtotal;

            const tr = document.createElement('tr');
            tr.innerHTML = `
                <td>${producto.nombre}</td>
                <td><input type="number" class="form-control cantidad-item" value="${producto.cantidad.toFixed(2)}" min="0.01" step="0.01" max="${producto.stock}" data-id="${producto.id}"></td>
                <td>$${producto.precio.toFixed(2)}</td>
                <td>$${subtotal.toFixed(2)}</td>
                <td><button type="button" class="btn btn-danger btn-sm btn-eliminar-item" data-id="${producto.id}"><i class="bi bi-trash"></i></button></td>
            `;
            tablaDetallesBody.appendChild(tr);
        });

        totalDisplay.textContent = `$${totalGeneral.toFixed(2)}`;
        
        // Actualizar inputs ocultos
        totalVentaInput.value = totalGeneral.toFixed(2);
        productosInput.value = JSON.stringify(productosEnVenta.map(p => ({ id: p.id, cantidad: p.cantidad, precio: p.precio })));
    }
    
    // Event listener para cambiar cantidad o eliminar item
    tablaDetallesBody.addEventListener('click', function(e) {
        if (e.target.classList.contains('btn-eliminar-item') || e.target.closest('.btn-eliminar-item')) {
            const btn = e.target.closest('.btn-eliminar-item');
            const productoId = btn.dataset.id;
            productosEnVenta = productosEnVenta.filter(p => p.id !== productoId);
            actualizarTablaYTotal();
        }
    });

    tablaDetallesBody.addEventListener('change', function(e) {
        if (e.target.classList.contains('cantidad-item')) {
            const input = e.target;
            const productoId = input.dataset.id;
            const nuevaCantidad = parseFloat(input.value); // Parsear como float

            const producto = productosEnVenta.find(p => p.id === productoId);
            if (producto) {
                if (nuevaCantidad > 0 && nuevaCantidad <= producto.stock) {
                    producto.cantidad = nuevaCantidad;
                } else {
                    input.value = producto.cantidad.toFixed(2); // Revertir si es inválido, formato a 2 decimales
                    alert(`La cantidad debe ser mayor a 0 y no exceder el stock disponible de ${producto.stock.toFixed(2)}.`);
                }
            }
            actualizarTablaYTotal();
        }
    });

    form.addEventListener('submit', function (e) {
        if (productosEnVenta.length === 0) {
            e.preventDefault();
            alert('Debe agregar al menos un producto a la venta.');
        }
        if (!document.getElementById('cliente').value) {
            e.preventDefault();
            alert('Debe seleccionar un cliente.');
        }
    });
});
</script>
