<?php
class Customers extends Controller
{
    private $customerModel;

    public function __construct()
    {
        if (!isLoggedIn()) {
            redirect('users/login');
        }
        $this->customerModel = $this->model('Customer');
    }

    public function index()
    {
        $customers = $this->customerModel->getCustomers();
        $data = ['customers' => $customers];
        $this->view('customers/index', $data);
    }

    public function add()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
            $data = [
                'ruc_cedula' => trim($_POST['ruc_cedula']),
                'nombre' => trim($_POST['nombre']),
                'direccion' => trim($_POST['direccion']),
                'telefono' => trim($_POST['telefono']),
                'email' => trim($_POST['email']),
                'nombre_err' => '',
                'ruc_err' => ''
            ];

            if (empty($data['nombre']))
                $data['nombre_err'] = 'Ingrese nombre';
            if (empty($data['ruc_cedula']))
                $data['ruc_err'] = 'Ingrese RUC/Cedula';

            if (empty($data['nombre_err']) && empty($data['ruc_err'])) {
                if ($this->customerModel->addCustomer($data)) {
                    flash('customer_message', 'Cliente agregado');
                    redirect('customers');
                } else {
                    die('Error al agregar');
                }
            } else {
                $this->view('customers/add', $data);
            }
        } else {
            $data = [
                'ruc_cedula' => '',
                'nombre' => '',
                'direccion' => '',
                'telefono' => '',
                'email' => '',
                'nombre_err' => '',
                'ruc_err' => ''
            ];
            $this->view('customers/add', $data);
        }
    }

    public function edit($id)
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
            $data = [
                'id' => $id,
                'ruc_cedula' => trim($_POST['ruc_cedula']),
                'nombre' => trim($_POST['nombre']),
                'direccion' => trim($_POST['direccion']),
                'telefono' => trim($_POST['telefono']),
                'email' => trim($_POST['email']),
                'nombre_err' => '',
                'ruc_err' => ''
            ];

            if (empty($data['nombre']))
                $data['nombre_err'] = 'Ingrese nombre';
            if (empty($data['ruc_cedula']))
                $data['ruc_err'] = 'Ingrese RUC/Cedula';

            if (empty($data['nombre_err']) && empty($data['ruc_err'])) {
                if ($this->customerModel->updateCustomer($data)) {
                    flash('customer_message', 'Cliente actualizado');
                    redirect('customers');
                } else {
                    die('Error al actualizar');
                }
            } else {
                $this->view('customers/edit', $data);
            }
        } else {
            $customer = $this->customerModel->getCustomerById($id);
            if ($customer) {
                $data = [
                    'id' => $id,
                    'ruc_cedula' => $customer->ruc_cedula,
                    'nombre' => $customer->nombre,
                    'direccion' => $customer->direccion,
                    'telefono' => $customer->telefono,
                    'email' => $customer->email,
                    'nombre_err' => '',
                    'ruc_err' => ''
                ];
                $this->view('customers/edit', $data);
            } else {
                redirect('customers');
            }
        }
    }

    public function delete($id)
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            if ($this->customerModel->deleteCustomer($id)) {
                flash('customer_message', 'Cliente eliminado');
                redirect('customers');
            }
        } else {
            redirect('customers');
        }
    }
}
