<?php
class Dashboard extends Controller
{
    private $saleModel;

    public function __construct()
    {
        if (!isLoggedIn()) {
            redirect('users/login');
        }
        $this->saleModel = $this->model('Sale');
    }

    public function index()
    {
        $count = $this->saleModel->countSalesToday();
        $sum = $this->saleModel->sumSalesToday();
        $recent = $this->saleModel->getRecentSales();

        $data = [
            'count_today' => $count,
            'sum_today' => $sum ?? 0,
            'recent_sales' => $recent
        ];

        $this->view('dashboard/index', $data);
    }
}
