<?php
class Products extends Controller
{
    private $productModel;

    public function __construct()
    {
        if (!isLoggedIn()) {
            redirect('users/login');
        }

        $this->productModel = $this->model('Product');
    }

    public function index()
    {
        $products = $this->productModel->getProducts();

        $data = [
            'products' => $products
        ];

        $this->view('products/index', $data);
    }

    public function add()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            // Sanitize POST array
            $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);

            $data = [
                'codigo' => trim($_POST['codigo']),
                'nombre' => trim($_POST['nombre']),
                'descripcion' => trim($_POST['descripcion']),
                'precio_compra' => trim($_POST['precio_compra']),
                'precio_venta_1' => trim($_POST['precio_venta_1']),
                'stock' => trim($_POST['stock']),
                'nombre_err' => ''
            ];

            // Validate data
            if (empty($data['nombre'])) {
                $data['nombre_err'] = 'Por favor ingrese nombre del producto';
            }

            // Make sure no errors
            if (empty($data['nombre_err'])) {
                // Validated
                if ($this->productModel->addProduct($data)) {
                    flash('product_message', 'Producto agregado');
                    redirect('products');
                } else {
                    die('Algo salió mal');
                }
            } else {
                // Load view with errors
                $this->view('products/add', $data);
            }

        } else {
            $data = [
                'codigo' => '',
                'nombre' => '',
                'descripcion' => '',
                'precio_compra' => '',
                'precio_venta_1' => '',
                'stock' => '',
                'nombre_err' => ''
            ];

            $this->view('products/add', $data);
        }
    }

    public function edit($id)
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            // Sanitize POST array
            $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);

            $data = [
                'id' => $id,
                'codigo' => trim($_POST['codigo']),
                'nombre' => trim($_POST['nombre']),
                'descripcion' => trim($_POST['descripcion']),
                'precio_compra' => trim($_POST['precio_compra']),
                'precio_venta_1' => trim($_POST['precio_venta_1']),
                'stock' => trim($_POST['stock']),
                'nombre_err' => ''
            ];

            if (empty($data['nombre'])) {
                $data['nombre_err'] = 'Por favor ingrese nombre del producto';
            }

            if (empty($data['nombre_err'])) {
                if ($this->productModel->updateProduct($data)) {
                    flash('product_message', 'Producto actualizado');
                    redirect('products');
                } else {
                    die('Algo salió mal');
                }
            } else {
                $this->view('products/edit', $data);
            }

        } else {
            $product = $this->productModel->getProductById($id);

            // Check if product exists
            if ($product) {
                $data = [
                    'id' => $id,
                    'codigo' => $product->codigo,
                    'nombre' => $product->nombre,
                    'descripcion' => $product->descripcion,
                    'precio_compra' => $product->precio_compra,
                    'precio_venta_1' => $product->precio_venta_1,
                    'stock' => $product->stock,
                    'nombre_err' => ''
                ];

                $this->view('products/edit', $data);
            } else {
                redirect('products');
            }
        }
    }

    public function delete($id)
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            if ($this->productModel->deleteProduct($id)) {
                flash('product_message', 'Producto eliminado');
                redirect('products');
            } else {
                die('Algo salió mal');
            }
        } else {
            redirect('products');
        }
    }
}
