<?php
class Reports extends Controller
{
    private $saleModel;

    public function __construct()
    {
        if (!isLoggedIn()) {
            redirect('users/login');
        }
        $this->saleModel = $this->model('Sale');
    }

    public function daily()
    {
        $sales = $this->saleModel->getDailySales();
        $totalSales = $this->saleModel->countSalesToday();
        $totalAmount = $this->saleModel->sumSalesToday();

        $data = [
            'title' => 'Reporte de Ventas Diarias',
            'sales' => $sales,
            'totalSales' => $totalSales,
            'totalAmount' => $totalAmount,
            'date' => date('Y-m-d')
        ];

        $this->view('reports/daily', $data);
    }

    public function monthly()
    {
        $sales = $this->saleModel->getMonthlySales();
        $totalSales = $this->saleModel->countSalesThisMonth();
        $totalAmount = $this->saleModel->sumSalesThisMonth();

        $data = [
            'title' => 'Reporte de Ventas Mensuales',
            'sales' => $sales,
            'totalSales' => $totalSales,
            'totalAmount' => $totalAmount,
            'month' => date('Y-m')
        ];

        $this->view('reports/monthly', $data);
    }

    public function annual()
    {
        $sales = $this->saleModel->getAnnualSales();
        $totalSales = $this->saleModel->countSalesThisYear();
        $totalAmount = $this->saleModel->sumSalesThisYear();

        $data = [
            'title' => 'Reporte de Ventas Anuales',
            'sales' => $sales,
            'totalSales' => $totalSales,
            'totalAmount' => $totalAmount,
            'year' => date('Y')
        ];

        $this->view('reports/annual', $data);
    }
}
