<?php
class Sales extends Controller
{
    private $saleModel;
    private $productModel;
    private $customerModel;

    public function __construct()
    {
        if (!isLoggedIn()) {
            redirect('users/login');
        }
        $this->saleModel = $this->model('Sale');
        $this->productModel = $this->model('Product');
        $this->customerModel = $this->model('Customer');
    }

    public function index()
    {
        $this->view('sales/index');
    }

    public function create()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            // Get raw JSON input
            $json = file_get_contents('php://input');
            $data = json_decode($json, true);

            if (!$data) {
                header('Content-Type: application/json');
                echo json_encode(['status' => 'error', 'message' => 'Invalid data']);
                return;
            }

            // Prepare Data
            $saleData = [
                'cliente_id' => $data['client_id'],
                'usuario_id' => $_SESSION['user_id'],
                'total' => $data['total'],
                'tipo_pago' => 'efectivo' // Default or passed from frontend
            ];

            $cart = $data['cart'];

            $saleId = $this->saleModel->createSale($saleData, $cart);

            header('Content-Type: application/json');
            if ($saleId) {
                echo json_encode(['status' => 'success', 'sale_id' => $saleId]);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Could not create sale']);
            }
        }
    }

    public function receipt($id)
    {
        $sale = $this->saleModel->getSaleById($id);
        $details = $this->saleModel->getSaleDetails($id);

        $data = [
            'sale' => $sale,
            'details' => $details
        ];

        $this->view('sales/receipt', $data);
    }

    // API Methods
    public function api_search_products($term)
    {
        // Basic search, could be improved with SQL LIKE in Model
        // For simplicity, reusing getProducts and filtering in PHP or assumes Model has search
        // Adding search method to Product Model dynamically here or reusing getProducts

        $products = $this->productModel->getProducts();
        $results = [];

        foreach ($products as $p) {
            if (stripos($p->nombre, $term) !== false || stripos($p->codigo, $term) !== false) {
                $results[] = $p;
            }
        }

        header('Content-Type: application/json');
        echo json_encode($results);
    }

    public function api_search_customers($term)
    {
        $customers = $this->customerModel->getCustomers();
        $results = [];

        foreach ($customers as $c) {
            if (stripos($c->nombre, $term) !== false || stripos($c->ruc_cedula, $term) !== false) {
                $results[] = $c;
            }
        }

        header('Content-Type: application/json');
        echo json_encode($results);
    }
}
