<?php
class Customer
{
    private $db;

    public function __construct()
    {
        $this->db = new Database;
    }

    public function getCustomers()
    {
        $this->db->query('SELECT * FROM clientes ORDER BY created_at DESC');
        return $this->db->resultSet();
    }

    public function addCustomer($data)
    {
        $this->db->query('INSERT INTO clientes (ruc_cedula, nombre, direccion, telefono, email) VALUES(:ruc_cedula, :nombre, :direccion, :telefono, :email)');
        $this->db->bind(':ruc_cedula', $data['ruc_cedula']);
        $this->db->bind(':nombre', $data['nombre']);
        $this->db->bind(':direccion', $data['direccion']);
        $this->db->bind(':telefono', $data['telefono']);
        $this->db->bind(':email', $data['email']);

        if ($this->db->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function updateCustomer($data)
    {
        $this->db->query('UPDATE clientes SET ruc_cedula = :ruc_cedula, nombre = :nombre, direccion = :direccion, telefono = :telefono, email = :email WHERE id = :id');
        $this->db->bind(':id', $data['id']);
        $this->db->bind(':ruc_cedula', $data['ruc_cedula']);
        $this->db->bind(':nombre', $data['nombre']);
        $this->db->bind(':direccion', $data['direccion']);
        $this->db->bind(':telefono', $data['telefono']);
        $this->db->bind(':email', $data['email']);

        if ($this->db->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function deleteCustomer($id)
    {
        $this->db->query('DELETE FROM clientes WHERE id = :id');
        $this->db->bind(':id', $id);

        if ($this->db->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function getCustomerById($id)
    {
        $this->db->query('SELECT * FROM clientes WHERE id = :id');
        $this->db->bind(':id', $id);
        return $this->db->single();
    }
}
