<?php
class Product
{
    private $db;

    public function __construct()
    {
        $this->db = new Database;
    }

    public function getProducts()
    {
        $this->db->query('SELECT * FROM productos ORDER BY created_at DESC');
        return $this->db->resultSet();
    }

    public function addProduct($data)
    {
        $this->db->query('INSERT INTO productos (codigo, nombre, descripcion, precio_compra, precio_venta_1, stock) VALUES(:codigo, :nombre, :descripcion, :precio_compra, :precio_venta_1, :stock)');
        // Bind values
        $this->db->bind(':codigo', $data['codigo']);
        $this->db->bind(':nombre', $data['nombre']);
        $this->db->bind(':descripcion', $data['descripcion']);
        $this->db->bind(':precio_compra', $data['precio_compra']);
        $this->db->bind(':precio_venta_1', $data['precio_venta_1']);
        $this->db->bind(':stock', $data['stock']);

        if ($this->db->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function updateProduct($data)
    {
        $this->db->query('UPDATE productos SET codigo = :codigo, nombre = :nombre, descripcion = :descripcion, precio_compra = :precio_compra, precio_venta_1 = :precio_venta_1, stock = :stock WHERE id = :id');
        // Bind values
        $this->db->bind(':id', $data['id']);
        $this->db->bind(':codigo', $data['codigo']);
        $this->db->bind(':nombre', $data['nombre']);
        $this->db->bind(':descripcion', $data['descripcion']);
        $this->db->bind(':precio_compra', $data['precio_compra']);
        $this->db->bind(':precio_venta_1', $data['precio_venta_1']);
        $this->db->bind(':stock', $data['stock']);

        if ($this->db->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function deleteProduct($id)
    {
        $this->db->query('DELETE FROM productos WHERE id = :id');
        $this->db->bind(':id', $id);

        if ($this->db->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function getProductById($id)
    {
        $this->db->query('SELECT * FROM productos WHERE id = :id');
        $this->db->bind(':id', $id);
        $row = $this->db->single();
        return $row;
    }
}
