<?php
class User
{
    private $db;

    public function __construct()
    {
        $this->db = new Database;
    }

    // Login User
    public function login($usuario, $password)
    {
        $this->db->query('SELECT * FROM usuarios WHERE usuario = :usuario');
        $this->db->bind(':usuario', $usuario);

        $row = $this->db->single();

        // Check password
        if ($row) {
            // Verify Password
            // In a real app with hashed passwords: if(password_verify($password, $row->password))
            // Current schema has a hash stored, assuming password_verify
            if (password_verify($password, $row->password)) {
                return $row;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    // Find user by email/username
    public function findUserByUsername($usuario)
    {
        $this->db->query('SELECT * FROM usuarios WHERE usuario = :usuario');
        $this->db->bind(':usuario', $usuario);

        $row = $this->db->single();

        // Check row
        if ($this->db->rowCount() > 0) {
            return true;
        } else {
            return false;
        }
    }

    // Get user by ID
    public function getUserById($id)
    {
        $this->db->query('SELECT * FROM usuarios WHERE id = :id');
        $this->db->bind(':id', $id);
        return $this->db->single();
    }

    // Update user information (name and username)
    public function updateUser($data)
    {
        $this->db->query('UPDATE usuarios SET nombre = :nombre, usuario = :usuario WHERE id = :id');
        $this->db->bind(':nombre', $data['nombre']);
        $this->db->bind(':usuario', $data['usuario']);
        $this->db->bind(':id', $data['id']);

        if ($this->db->execute()) {
            return true;
        } else {
            return false;
        }
    }

    // Update user password
    public function updatePassword($id, $password)
    {
        $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

        $this->db->query('UPDATE usuarios SET password = :password WHERE id = :id');
        $this->db->bind(':password', $hashedPassword);
        $this->db->bind(':id', $id);

        if ($this->db->execute()) {
            return true;
        } else {
            return false;
        }
    }

    // Check if username exists (excluding current user)
    public function checkUsernameExists($usuario, $excludeId)
    {
        $this->db->query('SELECT * FROM usuarios WHERE usuario = :usuario AND id != :id');
        $this->db->bind(':usuario', $usuario);
        $this->db->bind(':id', $excludeId);

        $row = $this->db->single();

        if ($this->db->rowCount() > 0) {
            return true;
        } else {
            return false;
        }
    }
}

