<?php require APPROOT . '/views/inc/header.php'; ?>
<a href="<?php echo URLROOT; ?>/customers" class="btn btn-light"><i class="fa fa-backward"></i> Volver</a>
<div class="card card-body bg-light mt-5">
    <h2>Editar Cliente</h2>
    <form action="<?php echo URLROOT; ?>/customers/edit/<?php echo $data['id']; ?>" method="post">
        <div class="form-group mb-3">
            <label for="ruc_cedula">RUC / Cédula: <sup>*</sup></label>
            <input type="text" name="ruc_cedula"
                class="form-control form-control-lg <?php echo (!empty($data['ruc_err'])) ? 'is-invalid' : ''; ?>"
                value="<?php echo $data['ruc_cedula']; ?>">
            <span class="invalid-feedback"><?php echo $data['ruc_err']; ?></span>
        </div>
        <div class="form-group mb-3">
            <label for="nombre">Nombre: <sup>*</sup></label>
            <input type="text" name="nombre"
                class="form-control form-control-lg <?php echo (!empty($data['nombre_err'])) ? 'is-invalid' : ''; ?>"
                value="<?php echo $data['nombre']; ?>">
            <span class="invalid-feedback"><?php echo $data['nombre_err']; ?></span>
        </div>
        <div class="form-group mb-3">
            <label for="direccion">Dirección:</label>
            <input type="text" name="direccion" class="form-control form-control-lg"
                value="<?php echo $data['direccion']; ?>">
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group mb-3">
                    <label for="telefono">Teléfono:</label>
                    <input type="text" name="telefono" class="form-control form-control-lg"
                        value="<?php echo $data['telefono']; ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group mb-3">
                    <label for="email">Email:</label>
                    <input type="email" name="email" class="form-control form-control-lg"
                        value="<?php echo $data['email']; ?>">
                </div>
            </div>
        </div>
        <div class="d-flex justify-content-between">
            <input type="submit" class="btn btn-success" value="Actualizar">
            <button type="button" class="btn btn-danger"
                onclick="if(confirm('¿Seguro de eliminar este cliente?')) document.getElementById('del-cust-<?php echo $data['id']; ?>').submit();">Eliminar</button>
        </div>
    </form>
    <form id="del-cust-<?php echo $data['id']; ?>"
        action="<?php echo URLROOT; ?>/customers/delete/<?php echo $data['id']; ?>" method="post"
        style="display: none;"></form>
</div>
<?php require APPROOT . '/views/inc/footer.php'; ?>