<?php require APPROOT . '/views/inc/header.php'; ?>
<div class="row mb-3">
    <div class="col-md-6">
        <h1>Clientes</h1>
    </div>
    <div class="col-md-6">
        <a href="<?php echo URLROOT; ?>/customers/add" class="btn btn-primary float-end">
            <i class="fa fa-user-plus"></i> Agregar Cliente
        </a>
    </div>
</div>
<?php flash('customer_message'); ?>
<div class="card card-body mb-3">
    <div class="table-responsive">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>RUC/Cédula</th>
                    <th>Nombre</th>
                    <th>Teléfono</th>
                    <th>Email</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($data['customers'] as $customer): ?>
                    <tr>
                        <td><?php echo $customer->ruc_cedula; ?></td>
                        <td><?php echo $customer->nombre; ?></td>
                        <td><?php echo $customer->telefono; ?></td>
                        <td><?php echo $customer->email; ?></td>
                        <td>
                            <a href="<?php echo URLROOT; ?>/customers/edit/<?php echo $customer->id; ?>"
                                class="btn btn-dark btn-sm">Editar</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php require APPROOT . '/views/inc/footer.php'; ?>