<?php require APPROOT . '/views/inc/header.php'; ?>
<div class="row mb-3">
    <div class="col-md-12">
        <h1>Dashboard</h1>
        <p class="lead">Bienvenido, <?php echo $_SESSION['user_name']; ?></p>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-6">
        <div class="card text-white bg-primary mb-3">
            <div class="card-header">Ventas de Hoy</div>
            <div class="card-body">
                <h5 class="card-title"><?php echo $data['count_today']; ?> ventas</h5>
                <p class="card-text">Total recaudado: $<?php echo number_format($data['sum_today'], 2); ?></p>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card text-white bg-success mb-3">
            <div class="card-header">Acciones Rápidas</div>
            <div class="card-body">
                <a href="<?php echo URLROOT; ?>/sales" class="btn btn-light btn-block">Nueva Venta</a>
                <a href="<?php echo URLROOT; ?>/products/add" class="btn btn-light btn-block">Agregar Producto</a>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        Ventas Recientes
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Fecha</th>
                        <th>Cliente</th>
                        <th>Total</th>
                        <th>Ver</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($data['recent_sales'] as $sale): ?>
                        <tr>
                            <td><?php echo $sale->id; ?></td>
                            <td><?php echo $sale->fecha; ?></td>
                            <td><?php echo $sale->cliente; ?></td>
                            <td>$<?php echo $sale->total; ?></td>
                            <td><a href="<?php echo URLROOT; ?>/sales/receipt/<?php echo $sale->id; ?>"
                                    class="btn btn-sm btn-info">Ver</a></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php require APPROOT . '/views/inc/footer.php'; ?>