<?php require APPROOT . '/views/inc/header.php'; ?>
<a href="<?php echo URLROOT; ?>/products" class="btn btn-light"><i class="fa fa-backward"></i> Volver</a>
<div class="card card-body bg-light mt-5">
    <h2>Agregar Producto</h2>
    <p>Crea un nuevo producto con su inventario inicial</p>
    <form action="<?php echo URLROOT; ?>/products/add" method="post">
        <div class="form-group mb-3">
            <label for="codigo">Código: <sup>*</sup></label>
            <input type="text" name="codigo" class="form-control form-control-lg"
                value="<?php echo $data['codigo']; ?>">
        </div>
        <div class="form-group mb-3">
            <label for="nombre">Nombre: <sup>*</sup></label>
            <input type="text" name="nombre"
                class="form-control form-control-lg <?php echo (!empty($data['nombre_err'])) ? 'is-invalid' : ''; ?>"
                value="<?php echo $data['nombre']; ?>">
            <span class="invalid-feedback"><?php echo $data['nombre_err']; ?></span>
        </div>
        <div class="form-group mb-3">
            <label for="descripcion">Descripción:</label>
            <textarea name="descripcion"
                class="form-control form-control-lg"><?php echo $data['descripcion']; ?></textarea>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group mb-3">
                    <label for="precio_compra">Precio Compra:</label>
                    <input type="number" step="0.01" name="precio_compra" class="form-control form-control-lg"
                        value="<?php echo $data['precio_compra']; ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group mb-3">
                    <label for="precio_venta_1">Precio Venta:</label>
                    <input type="number" step="0.01" name="precio_venta_1" class="form-control form-control-lg"
                        value="<?php echo $data['precio_venta_1']; ?>">
                </div>
            </div>
        </div>
        <div class="form-group mb-3">
            <label for="stock">Stock Inicial:</label>
            <input type="number" name="stock" class="form-control form-control-lg"
                value="<?php echo $data['stock']; ?>">
        </div>
        <input type="submit" class="btn btn-success" value="Guardar Producto">
    </form>
</div>
<?php require APPROOT . '/views/inc/footer.php'; ?>