<?php require APPROOT . '/views/inc/header.php'; ?>
<a href="<?php echo URLROOT; ?>/products" class="btn btn-light"><i class="fa fa-backward"></i> Volver</a>
<div class="card card-body bg-light mt-5">
    <h2>Editar Producto</h2>
    <form action="<?php echo URLROOT; ?>/products/edit/<?php echo $data['id']; ?>" method="post">
        <div class="form-group mb-3">
            <label for="codigo">Código: <sup>*</sup></label>
            <input type="text" name="codigo" class="form-control form-control-lg"
                value="<?php echo $data['codigo']; ?>">
        </div>
        <div class="form-group mb-3">
            <label for="nombre">Nombre: <sup>*</sup></label>
            <input type="text" name="nombre"
                class="form-control form-control-lg <?php echo (!empty($data['nombre_err'])) ? 'is-invalid' : ''; ?>"
                value="<?php echo $data['nombre']; ?>">
            <span class="invalid-feedback"><?php echo $data['nombre_err']; ?></span>
        </div>
        <div class="form-group mb-3">
            <label for="descripcion">Descripción:</label>
            <textarea name="descripcion"
                class="form-control form-control-lg"><?php echo $data['descripcion']; ?></textarea>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group mb-3">
                    <label for="precio_compra">Precio Compra:</label>
                    <input type="number" step="0.01" name="precio_compra" class="form-control form-control-lg"
                        value="<?php echo $data['precio_compra']; ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group mb-3">
                    <label for="precio_venta_1">Precio Venta:</label>
                    <input type="number" step="0.01" name="precio_venta_1" class="form-control form-control-lg"
                        value="<?php echo $data['precio_venta_1']; ?>">
                </div>
            </div>
        </div>
        <div class="form-group mb-3">
            <label for="stock">Stock Actual:</label>
            <input type="number" name="stock" class="form-control form-control-lg"
                value="<?php echo $data['stock']; ?>">
        </div>
        <div class="d-flex justify-content-between">
            <input type="submit" class="btn btn-success" value="Actualizar">
            <button type="button" class="btn btn-danger"
                onclick="if(confirm('¿Estás seguro de eliminar este producto?')) document.getElementById('delete-form-<?php echo $data['id']; ?>').submit();">Eliminar</button>
        </div>
    </form>
    <form id="delete-form-<?php echo $data['id']; ?>"
        action="<?php echo URLROOT; ?>/products/delete/<?php echo $data['id']; ?>" method="post" style="display: none;">
    </form>
</div>
<?php require APPROOT . '/views/inc/footer.php'; ?>