<?php require APPROOT . '/views/inc/header.php'; ?>
<div class="row mb-3">
    <div class="col-md-6">
        <h1>Productos</h1>
    </div>
    <div class="col-md-6">
        <a href="<?php echo URLROOT; ?>/products/add" class="btn btn-primary float-end">
            <i class="fa fa-pencil"></i> Agregar Producto
        </a>
    </div>
</div>
<?php flash('product_message'); ?>
<div class="card card-body mb-3">
    <div class="table-responsive">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Código</th>
                    <th>Nombre</th>
                    <th>P. Compra</th>
                    <th>P. Venta</th>
                    <th>Stock</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($data['products'] as $product): ?>
                    <tr>
                        <td><?php echo $product->codigo; ?></td>
                        <td><?php echo $product->nombre; ?></td>
                        <td>$<?php echo $product->precio_compra; ?></td>
                        <td>$<?php echo $product->precio_venta_1; ?></td>
                        <td><?php echo $product->stock; ?></td>
                        <td>
                            <a href="<?php echo URLROOT; ?>/products/edit/<?php echo $product->id; ?>"
                                class="btn btn-dark btn-sm">Editar</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php require APPROOT . '/views/inc/footer.php'; ?>