<?php require APPROOT . '/views/inc/header.php'; ?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header bg-info text-white">
                <h4><i class="fas fa-calendar"></i> <?php echo $data['title']; ?></h4>
                <p class="mb-0">Año: <?php echo $data['year']; ?></p>
            </div>
            <div class="card-body">
                <?php if (empty($data['sales'])): ?>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> No hay ventas registradas para este año.
                    </div>
                <?php else: ?>
                    <!-- Resumen del Año -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card border-primary">
                                <div class="card-body text-center">
                                    <i class="fas fa-shopping-cart fa-3x text-primary mb-3"></i>
                                    <h6 class="text-muted mb-1">Total Ventas</h6>
                                    <h2 class="text-primary mb-0"><?php echo $data['totalSales']; ?></h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-success">
                                <div class="card-body text-center">
                                    <i class="fas fa-dollar-sign fa-3x text-success mb-3"></i>
                                    <h6 class="text-muted mb-1">Monto Total</h6>
                                    <h2 class="text-success mb-0">$<?php echo number_format($data['totalAmount'], 2); ?>
                                    </h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-info">
                                <div class="card-body text-center">
                                    <i class="fas fa-chart-line fa-3x text-info mb-3"></i>
                                    <h6 class="text-muted mb-1">Promedio Mensual</h6>
                                    <h2 class="text-info mb-0">
                                        $<?php echo count($data['sales']) > 0 ? number_format($data['totalAmount'] / count($data['sales']), 2) : '0.00'; ?>
                                    </h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-warning">
                                <div class="card-body text-center">
                                    <i class="fas fa-trophy fa-3x text-warning mb-3"></i>
                                    <h6 class="text-muted mb-1">Mejor Mes</h6>
                                    <?php
                                    $meses = ['', 'Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'];
                                    $mejorMes = 0;
                                    $mejorTotal = 0;
                                    foreach ($data['sales'] as $sale) {
                                        if ($sale->total_mes > $mejorTotal) {
                                            $mejorTotal = $sale->total_mes;
                                            $mejorMes = $sale->mes;
                                        }
                                    }
                                    ?>
                                    <h2 class="text-warning mb-0"><?php echo $mejorMes > 0 ? $meses[$mejorMes] : '--'; ?>
                                    </h2>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tabla de Ventas por Mes -->
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>Mes</th>
                                    <th class="text-center">Número de Ventas</th>
                                    <th class="text-end">Total del Mes</th>
                                    <th class="text-end">% del Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $meses = [
                                    '',
                                    'Enero',
                                    'Febrero',
                                    'Marzo',
                                    'Abril',
                                    'Mayo',
                                    'Junio',
                                    'Julio',
                                    'Agosto',
                                    'Septiembre',
                                    'Octubre',
                                    'Noviembre',
                                    'Diciembre'
                                ];
                                foreach ($data['sales'] as $sale):
                                    $porcentaje = ($sale->total_mes / $data['totalAmount']) * 100;
                                    ?>
                                    <tr>
                                        <td><strong><?php echo $meses[$sale->mes]; ?></strong></td>
                                        <td class="text-center"><span
                                                class="badge bg-primary"><?php echo $sale->num_ventas; ?></span></td>
                                        <td class="text-end">$<?php echo number_format($sale->total_mes, 2); ?></td>
                                        <td class="text-end">
                                            <div class="progress" style="height: 20px;">
                                                <div class="progress-bar bg-success" role="progressbar"
                                                    style="width: <?php echo $porcentaje; ?>%"
                                                    aria-valuenow="<?php echo $porcentaje; ?>" aria-valuemin="0"
                                                    aria-valuemax="100">
                                                    <?php echo number_format($porcentaje, 1); ?>%
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot class="table-secondary">
                                <tr>
                                    <th class="text-end">Total del Año:</th>
                                    <th class="text-center"><?php echo $data['totalSales']; ?></th>
                                    <th class="text-end">$<?php echo number_format($data['totalAmount'], 2); ?></th>
                                    <th class="text-end">100%</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php require APPROOT . '/views/inc/footer.php'; ?>