<?php require APPROOT . '/views/inc/header.php'; ?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h4><i class="fas fa-calendar-day"></i> <?php echo $data['title']; ?></h4>
                <p class="mb-0">Fecha: <?php echo date('d/m/Y', strtotime($data['date'])); ?></p>
            </div>
            <div class="card-body">
                <!-- Cuadros Estadísticos -->
                <div class="row mb-4">
                    <div class="col-md-3">
                        <div class="card border-primary">
                            <div class="card-body text-center">
                                <i class="fas fa-shopping-cart fa-2x text-primary mb-2"></i>
                                <h6 class="text-muted mb-1">Total Ventas</h6>
                                <h3 class="text-primary mb-0"><?php echo $data['totalSales']; ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card border-success">
                            <div class="card-body text-center">
                                <i class="fas fa-dollar-sign fa-2x text-success mb-2"></i>
                                <h6 class="text-muted mb-1">Monto Total</h6>
                                <h3 class="text-success mb-0">$<?php echo number_format($data['totalAmount'], 2); ?>
                                </h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card border-info">
                            <div class="card-body text-center">
                                <i class="fas fa-receipt fa-2x text-info mb-2"></i>
                                <h6 class="text-muted mb-1">Ticket Promedio</h6>
                                <h3 class="text-info mb-0">
                                    $<?php echo $data['totalSales'] > 0 ? number_format($data['totalAmount'] / $data['totalSales'], 2) : '0.00'; ?>
                                </h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card border-warning">
                            <div class="card-body text-center">
                                <i class="fas fa-clock fa-2x text-warning mb-2"></i>
                                <h6 class="text-muted mb-1">Última Venta</h6>
                                <h3 class="text-warning mb-0">
                                    <?php echo !empty($data['sales']) ? date('H:i', strtotime($data['sales'][0]->fecha)) : '--:--'; ?>
                                </h3>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if (empty($data['sales'])): ?>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> No hay ventas registradas para el día de hoy.
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>ID</th>
                                    <th>Hora</th>
                                    <th>Cliente</th>
                                    <th>RUC/Cédula</th>
                                    <th>Vendedor</th>
                                    <th>Tipo Pago</th>
                                    <th class="text-end">Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($data['sales'] as $sale): ?>
                                    <tr>
                                        <td><?php echo $sale->id; ?></td>
                                        <td><?php echo date('H:i:s', strtotime($sale->fecha)); ?></td>
                                        <td><?php echo $sale->cliente_nombre; ?></td>
                                        <td><?php echo $sale->ruc_cedula; ?></td>
                                        <td><?php echo $sale->vendedor_nombre; ?></td>
                                        <td><span class="badge bg-info"><?php echo ucfirst($sale->tipo_pago); ?></span></td>
                                        <td class="text-end">$<?php echo number_format($sale->total, 2); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot class="table-secondary">
                                <tr>
                                    <th colspan="6" class="text-end">Total de Ventas:</th>
                                    <th class="text-end"><?php echo $data['totalSales']; ?></th>
                                </tr>
                                <tr>
                                    <th colspan="6" class="text-end">Monto Total:</th>
                                    <th class="text-end">$<?php echo number_format($data['totalAmount'], 2); ?></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php require APPROOT . '/views/inc/footer.php'; ?>