<?php require APPROOT . '/views/inc/header.php'; ?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header bg-success text-white">
                <h4><i class="fas fa-calendar-alt"></i> <?php echo $data['title']; ?></h4>
                <p class="mb-0">Mes: <?php echo date('F Y', strtotime($data['month'])); ?></p>
            </div>
            <div class="card-body">
                <?php if (empty($data['sales'])): ?>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> No hay ventas registradas para este mes.
                    </div>
                <?php else: ?>
                    <!-- Resumen del Mes -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card border-primary">
                                <div class="card-body text-center">
                                    <i class="fas fa-shopping-cart fa-3x text-primary mb-3"></i>
                                    <h6 class="text-muted mb-1">Total Ventas</h6>
                                    <h2 class="text-primary mb-0"><?php echo $data['totalSales']; ?></h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-success">
                                <div class="card-body text-center">
                                    <i class="fas fa-dollar-sign fa-3x text-success mb-3"></i>
                                    <h6 class="text-muted mb-1">Monto Total</h6>
                                    <h2 class="text-success mb-0">$<?php echo number_format($data['totalAmount'], 2); ?>
                                    </h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-info">
                                <div class="card-body text-center">
                                    <i class="fas fa-chart-line fa-3x text-info mb-3"></i>
                                    <h6 class="text-muted mb-1">Promedio Diario</h6>
                                    <h2 class="text-info mb-0">
                                        $<?php echo count($data['sales']) > 0 ? number_format($data['totalAmount'] / count($data['sales']), 2) : '0.00'; ?>
                                    </h2>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-warning">
                                <div class="card-body text-center">
                                    <i class="fas fa-calendar-day fa-3x text-warning mb-3"></i>
                                    <h6 class="text-muted mb-1">Días con Ventas</h6>
                                    <h2 class="text-warning mb-0"><?php echo count($data['sales']); ?></h2>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tabla de Ventas por Día -->
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>Fecha</th>
                                    <th>Día</th>
                                    <th class="text-center">Número de Ventas</th>
                                    <th class="text-end">Total del Día</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($data['sales'] as $sale): ?>
                                    <tr>
                                        <td><?php echo date('d/m/Y', strtotime($sale->fecha)); ?></td>
                                        <td><?php echo strftime('%A', strtotime($sale->fecha)); ?></td>
                                        <td class="text-center"><span
                                                class="badge bg-primary"><?php echo $sale->num_ventas; ?></span></td>
                                        <td class="text-end">$<?php echo number_format($sale->total_dia, 2); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot class="table-secondary">
                                <tr>
                                    <th colspan="2" class="text-end">Total del Mes:</th>
                                    <th class="text-center"><?php echo $data['totalSales']; ?></th>
                                    <th class="text-end">$<?php echo number_format($data['totalAmount'], 2); ?></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php require APPROOT . '/views/inc/footer.php'; ?>