<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Recibo de Venta</title>
    <style>
        body {
            font-family: 'Courier New', Courier, monospace;
            font-size: 12px;
            width: 58mm;
            margin: 0;
            padding: 4px;
        }

        .header,
        .footer {
            text-align: center;
        }

        .bold {
            font-weight: bold;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        td,
        th {
            text-align: left;
            border-bottom: 1px dashed #000;
        }

        .right {
            text-align: right;
        }

        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>

<body onload="window.print()">
    <div class="header">
        <h3 style="margin:0;"><?php echo SITENAME; ?></h3>
        <p style="margin:0;">RUC: 1204590283001</p>
        <p style="margin:0;">CALLE TERCERA Y CALDERON</p>
        <p style="margin:0;">DIAGONAL AL REGISTRO CIVIL</p>
        <p>--------------------------------</p>
    </div>

    <div>
        <strong>Fecha:</strong> <?php echo $data['sale']->fecha; ?><br>
        <strong>Cliente:</strong> <?php echo $data['sale']->cliente_nombre; ?><br>
        <strong>RUC/CI:</strong> <?php echo $data['sale']->ruc_cedula; ?><br>
        <strong>Vendedor:</strong> <?php echo $data['sale']->vendedor_nombre; ?><br>
    </div>
    <p>--------------------------------</p>
    <table>
        <thead>
            <tr>
                <th>Cant</th>
                <th>Prod</th>
                <th class="right">Total</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($data['details'] as $item): ?>
                <tr>
                    <td><?php echo $item->cantidad; ?></td>
                    <td><?php echo substr($item->producto_nombre, 0, 15); ?></td>
                    <td class="right">$<?php echo $item->subtotal; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <p>--------------------------------</p>
    <div class="right">
        <strong style="font-size: 14px;">TOTAL: $<?php echo $data['sale']->total; ?></strong>
    </div>
    <p class="footer">¡Gracias por su compra!</p>

    <button class="no-print" onclick="window.location.href='<?php echo URLROOT; ?>/sales'">Volver</button>
</body>

</html>