<?php require APPROOT . '/views/inc/header.php'; ?>

<div class="row">
    <div class="col-md-8 mx-auto">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h4><i class="fas fa-user-circle"></i> Mi Perfil</h4>
            </div>
            <div class="card-body">
                <?php if (!empty($data['success_msg'])): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle"></i> <?php echo $data['success_msg']; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <form action="<?php echo URLROOT; ?>/users/profile" method="post">
                    <!-- Información Personal -->
                    <div class="mb-4">
                        <h5 class="border-bottom pb-2"><i class="fas fa-user"></i> Información Personal</h5>

                        <div class="mb-3">
                            <label for="nombre" class="form-label">Nombre Completo <span
                                    class="text-danger">*</span></label>
                            <input type="text" name="nombre"
                                class="form-control <?php echo (!empty($data['nombre_err'])) ? 'is-invalid' : ''; ?>"
                                value="<?php echo $data['nombre']; ?>">
                            <span class="invalid-feedback"><?php echo $data['nombre_err']; ?></span>
                        </div>

                        <div class="mb-3">
                            <label for="usuario" class="form-label">Usuario <span class="text-danger">*</span></label>
                            <input type="text" name="usuario"
                                class="form-control <?php echo (!empty($data['usuario_err'])) ? 'is-invalid' : ''; ?>"
                                value="<?php echo $data['usuario']; ?>">
                            <span class="invalid-feedback"><?php echo $data['usuario_err']; ?></span>
                            <small class="form-text text-muted">Este es el nombre que usas para iniciar sesión</small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Rol</label>
                            <input type="text" class="form-control" value="<?php echo ucfirst($data['user']->rol); ?>"
                                disabled>
                            <small class="form-text text-muted">El rol no puede ser modificado</small>
                        </div>
                    </div>

                    <!-- Cambiar Contraseña -->
                    <div class="mb-4">
                        <h5 class="border-bottom pb-2"><i class="fas fa-lock"></i> Cambiar Contraseña</h5>
                        <p class="text-muted small">Deja estos campos en blanco si no deseas cambiar tu contraseña</p>

                        <div class="mb-3">
                            <label for="current_password" class="form-label">Contraseña Actual</label>
                            <input type="password" name="current_password"
                                class="form-control <?php echo (!empty($data['current_password_err'])) ? 'is-invalid' : ''; ?>"
                                value="<?php echo $data['current_password']; ?>">
                            <span class="invalid-feedback"><?php echo $data['current_password_err']; ?></span>
                        </div>

                        <div class="mb-3">
                            <label for="new_password" class="form-label">Nueva Contraseña</label>
                            <input type="password" name="new_password"
                                class="form-control <?php echo (!empty($data['new_password_err'])) ? 'is-invalid' : ''; ?>"
                                value="<?php echo $data['new_password']; ?>">
                            <span class="invalid-feedback"><?php echo $data['new_password_err']; ?></span>
                            <small class="form-text text-muted">Mínimo 6 caracteres</small>
                        </div>

                        <div class="mb-3">
                            <label for="confirm_password" class="form-label">Confirmar Nueva Contraseña</label>
                            <input type="password" name="confirm_password"
                                class="form-control <?php echo (!empty($data['confirm_password_err'])) ? 'is-invalid' : ''; ?>"
                                value="<?php echo $data['confirm_password']; ?>">
                            <span class="invalid-feedback"><?php echo $data['confirm_password_err']; ?></span>
                        </div>
                    </div>

                    <!-- Botones -->
                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="<?php echo URLROOT; ?>" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Cancelar
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Guardar Cambios
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Información Adicional -->
        <div class="card mt-3">
            <div class="card-body">
                <h6 class="card-title"><i class="fas fa-info-circle"></i> Información de la Cuenta</h6>
                <p class="card-text mb-1"><strong>Fecha de Creación:</strong>
                    <?php echo date('d/m/Y H:i', strtotime($data['user']->created_at)); ?></p>
                <p class="card-text mb-0"><strong>ID de Usuario:</strong> #<?php echo $data['user']->id; ?></p>
            </div>
        </div>
    </div>
</div>

<?php require APPROOT . '/views/inc/footer.php'; ?>