<?php
// Script de diagnóstico completo de base de datos
echo "<h1>Diagnóstico de Base de Datos</h1>";
echo "<hr>";

// 1. Mostrar configuración
echo "<h2>1. Configuración Actual</h2>";
echo "<pre>";
echo "DB_HOST: " . (defined('DB_HOST') ? DB_HOST : 'NO DEFINIDO') . "\n";
echo "DB_USER: " . (defined('DB_USER') ? DB_USER : 'NO DEFINIDO') . "\n";
echo "DB_NAME: " . (defined('DB_NAME') ? DB_NAME : 'NO DEFINIDO') . "\n";
echo "</pre>";

require_once '../app/config/config.php';

echo "<pre>";
echo "DB_HOST: " . DB_HOST . "\n";
echo "DB_USER: " . DB_USER . "\n";
echo "DB_NAME: " . DB_NAME . "\n";
echo "</pre>";

// 2. Test de conexión PDO directo
echo "<h2>2. Test de Conexión PDO</h2>";
try {
    $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME;
    $pdo = new PDO($dsn, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "<p style='color: green;'>✓ Conexión PDO exitosa</p>";

    // 3. Listar todas las bases de datos
    echo "<h2>3. Bases de Datos Disponibles</h2>";
    $stmt = $pdo->query("SHOW DATABASES");
    $databases = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "<ul>";
    foreach ($databases as $db) {
        $highlight = ($db == DB_NAME) ? " <strong>(ACTUAL)</strong>" : "";
        echo "<li>{$db}{$highlight}</li>";
    }
    echo "</ul>";

    // 4. Verificar si la base de datos existe
    echo "<h2>4. Verificación de Base de Datos '{DB_NAME}'</h2>";
    if (in_array(DB_NAME, $databases)) {
        echo "<p style='color: green;'>✓ La base de datos '" . DB_NAME . "' existe</p>";

        // 5. Listar tablas
        echo "<h2>5. Tablas en '" . DB_NAME . "'</h2>";
        $stmt = $pdo->query("SHOW TABLES");
        $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
        if (count($tables) > 0) {
            echo "<ul>";
            foreach ($tables as $table) {
                echo "<li>{$table}</li>";
            }
            echo "</ul>";

            // 6. Contar registros en cada tabla
            echo "<h2>6. Conteo de Registros</h2>";
            echo "<table border='1' cellpadding='5'>";
            echo "<tr><th>Tabla</th><th>Registros</th></tr>";
            foreach ($tables as $table) {
                $stmt = $pdo->query("SELECT COUNT(*) FROM `{$table}`");
                $count = $stmt->fetchColumn();
                $color = ($count > 0) ? 'green' : 'red';
                echo "<tr><td>{$table}</td><td style='color: {$color};'><strong>{$count}</strong></td></tr>";
            }
            echo "</table>";

            // 7. Mostrar datos de productos si existen
            echo "<h2>7. Datos de Productos</h2>";
            $stmt = $pdo->query("SELECT * FROM productos LIMIT 10");
            $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if (count($products) > 0) {
                echo "<table border='1' cellpadding='5'>";
                echo "<tr><th>ID</th><th>Código</th><th>Nombre</th><th>P.Compra</th><th>P.Venta1</th><th>P.Venta2</th><th>Stock</th></tr>";
                foreach ($products as $p) {
                    echo "<tr>";
                    echo "<td>{$p['id']}</td>";
                    echo "<td>{$p['codigo']}</td>";
                    echo "<td>{$p['nombre']}</td>";
                    echo "<td>\${$p['precio_compra']}</td>";
                    echo "<td>\${$p['precio_venta_1']}</td>";
                    echo "<td>\${$p['precio_venta_2']}</td>";
                    echo "<td>{$p['stock']}</td>";
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p style='color: red;'>⚠ No hay productos en la tabla</p>";
            }

            // 8. Mostrar datos de clientes si existen
            echo "<h2>8. Datos de Clientes</h2>";
            $stmt = $pdo->query("SELECT * FROM clientes LIMIT 10");
            $customers = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if (count($customers) > 0) {
                echo "<table border='1' cellpadding='5'>";
                echo "<tr><th>ID</th><th>RUC/Cédula</th><th>Nombre</th><th>Teléfono</th><th>Email</th></tr>";
                foreach ($customers as $c) {
                    echo "<tr>";
                    echo "<td>{$c['id']}</td>";
                    echo "<td>{$c['ruc_cedula']}</td>";
                    echo "<td>{$c['nombre']}</td>";
                    echo "<td>{$c['telefono']}</td>";
                    echo "<td>{$c['email']}</td>";
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p style='color: red;'>⚠ No hay clientes en la tabla</p>";
            }

        } else {
            echo "<p style='color: red;'>✗ No hay tablas en la base de datos. Debes importar schema.sql</p>";
        }

    } else {
        echo "<p style='color: red;'>✗ La base de datos '" . DB_NAME . "' NO existe. Debes crearla e importar schema.sql</p>";
    }

} catch (PDOException $e) {
    echo "<p style='color: red;'>✗ Error de conexión: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h2>Instrucciones</h2>";
echo "<ol>";
echo "<li>Si la base de datos no existe: Créala en phpMyAdmin e importa <code>database/schema.sql</code></li>";
echo "<li>Si no hay tablas: Importa <code>database/schema.sql</code></li>";
echo "<li>Si no hay datos: Importa <code>database/insert_sample_data.sql</code> O agrega datos manualmente desde el sistema</li>";
echo "</ol>";
?>