const URLROOT = 'http://localhost/ventas/public';

let cart = [];

document.addEventListener('DOMContentLoaded', function () {
    const productSearchInput = document.getElementById('product_search');
    const productResults = document.getElementById('product_results');
    const customerSearchInput = document.getElementById('customer_search');
    const customerResults = document.getElementById('customer_results');
    const processSaleBtn = document.getElementById('btn_process_sale');

    if (productSearchInput) {
        productSearchInput.addEventListener('keyup', function (e) {
            const term = e.target.value;
            if (term.length > 1) {
                fetch(URLROOT + '/sales/api_search_products/' + term)
                    .then(res => res.json())
                    .then(data => {
                        let html = '';
                        data.forEach(product => {
                            html += `<a href="#" class="list-group-item list-group-item-action" onclick="addToCart(${product.id}, '${product.nombre}', ${product.precio_venta_1}, ${product.stock}); return false;">${product.nombre} - Stock: ${product.stock}</a>`;
                        });
                        productResults.innerHTML = html;
                    });
            } else {
                productResults.innerHTML = '';
            }
        });
    }

    if (customerSearchInput) {
        customerSearchInput.addEventListener('keyup', function (e) {
            const term = e.target.value;
            if (term.length > 2) {
                fetch(URLROOT + '/sales/api_search_customers/' + term)
                    .then(res => res.json())
                    .then(data => {
                        let html = '';
                        data.forEach(customer => {
                            html += `<a href="#" class="list-group-item list-group-item-action" onclick="selectCustomer(${customer.id}, '${customer.nombre}'); return false;">${customer.nombre} (${customer.ruc_cedula})</a>`;
                        });
                        customerResults.innerHTML = html;
                    });
            } else {
                customerResults.innerHTML = '';
            }
        });
    }

    if (processSaleBtn) {
        processSaleBtn.addEventListener('click', function () {
            const clientId = document.getElementById('selected_client_id').value;
            if (!clientId) {
                alert('Por favor seleccione un cliente');
                return;
            }
            if (cart.length === 0) {
                alert('El carrito está vacío');
                return;
            }

            const total = calculateTotal();
            const data = {
                client_id: clientId,
                total: total,
                cart: cart
            };

            fetch(URLROOT + '/sales/create', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(data)
            })
                .then(res => res.json())
                .then(res => {
                    if (res.status === 'success') {
                        window.location.href = URLROOT + '/sales/receipt/' + res.sale_id;
                    } else {
                        alert('Error al procesar venta');
                    }
                });
        });
    }
});

function addToCart(id, name, price, stock) {
    // Check if exists
    const existing = cart.find(item => item.id == id);
    if (existing) {
        if (existing.cantidad < stock) {
            existing.cantidad++;
            existing.subtotal = (existing.cantidad * existing.precio).toFixed(2);
        } else {
            alert('No hay suficiente stock');
        }
    } else {
        cart.push({
            id: id,
            nombre: name,
            precio: price,
            cantidad: 1,
            subtotal: price.toFixed(2),
            max_stock: stock
        });
    }

    document.getElementById('product_results').innerHTML = '';
    document.getElementById('product_search').value = '';
    renderCart();
}

function selectCustomer(id, name) {
    document.getElementById('selected_client_id').value = id;
    document.getElementById('selected_client_name').innerText = name;
    document.getElementById('customer_results').innerHTML = '';
    document.getElementById('customer_search').value = '';
}

function renderCart() {
    const tbody = document.getElementById('cart_body');
    let html = '';
    cart.forEach((item, index) => {
        html += `
            <tr>
                <td>
                    <div class="input-group input-group-sm" style="width: 150px;">
                        <button class="btn btn-sm btn-secondary" onclick="updateQty(${index}, -0.01)">-</button>
                        <input type="number" step="0.01" class="form-control" 
                               value="${item.cantidad}" 
                               onchange="updateQuantity(${index}, this.value)"
                               style="text-align: center;">
                        <button class="btn btn-sm btn-secondary" onclick="updateQty(${index}, 0.01)">+</button>
                    </div>
                </td>
                <td>${item.nombre}</td>
                <td>
                    <input type="number" step="0.01" class="form-control form-control-sm" 
                           value="${item.precio}" 
                           onchange="updatePrice(${index}, this.value)"
                           style="width: 100px;">
                </td>
                <td>$${item.subtotal}</td>
                <td><button class="btn btn-danger btn-sm" onclick="removeFromCart(${index})">X</button></td>
            </tr>
        `;
    });
    tbody.innerHTML = html;
    document.getElementById('cart_total').innerText = calculateTotal();
}

function updateQty(index, change) {
    const item = cart[index];
    const newQty = parseFloat((item.cantidad + change).toFixed(2));
    if (newQty > 0 && newQty <= item.max_stock) {
        item.cantidad = newQty;
        item.subtotal = (item.cantidad * item.precio).toFixed(2);
        renderCart();
    } else if (newQty > item.max_stock) {
        alert('No hay suficiente stock');
    } else if (newQty <= 0) {
        alert('La cantidad debe ser mayor a 0');
    }
}

function removeFromCart(index) {
    cart.splice(index, 1);
    renderCart();
}

function updatePrice(index, newPrice) {
    const price = parseFloat(newPrice);
    if (price > 0) {
        cart[index].precio = price;
        cart[index].subtotal = (cart[index].cantidad * price).toFixed(2);
        renderCart();
    } else {
        alert('El precio debe ser mayor a 0');
        renderCart();
    }
}

function updateQuantity(index, newQty) {
    const qty = parseFloat(newQty);
    if (qty > 0 && qty <= cart[index].max_stock) {
        cart[index].cantidad = qty;
        cart[index].subtotal = (qty * cart[index].precio).toFixed(2);
        renderCart();
    } else if (qty > cart[index].max_stock) {
        alert('Stock máximo: ' + cart[index].max_stock);
        renderCart();
    } else {
        alert('La cantidad debe ser mayor a 0');
        renderCart();
    }
}

function calculateTotal() {
    let total = 0;
    cart.forEach(item => {
        total += parseFloat(item.subtotal);
    });
    return total.toFixed(2);
}
