<?php
// Script para probar la conexión a la base de datos y verificar datos
require_once '../app/config/config.php';
require_once '../app/libraries/Database.php';

echo "<h2>Test de Conexión a Base de Datos</h2>";

try {
    $db = new Database();
    echo "<p style='color: green;'>✓ Conexión exitosa a la base de datos</p>";

    // Test productos
    $db->query('SELECT * FROM productos');
    $products = $db->resultSet();

    echo "<h3>Productos en la base de datos: " . count($products) . "</h3>";
    if (count($products) > 0) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Código</th><th>Nombre</th><th>Stock</th></tr>";
        foreach ($products as $p) {
            echo "<tr><td>{$p->id}</td><td>{$p->codigo}</td><td>{$p->nombre}</td><td>{$p->stock}</td></tr>";
        }
        echo "</table>";
    } else {
        echo "<p style='color: red;'>⚠ No hay productos en la base de datos</p>";
    }

    // Test clientes
    $db->query('SELECT * FROM clientes');
    $customers = $db->resultSet();

    echo "<h3>Clientes en la base de datos: " . count($customers) . "</h3>";
    if (count($customers) > 0) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>RUC/Cédula</th><th>Nombre</th></tr>";
        foreach ($customers as $c) {
            echo "<tr><td>{$c->id}</td><td>{$c->ruc_cedula}</td><td>{$c->nombre}</td></tr>";
        }
        echo "</table>";
    } else {
        echo "<p style='color: red;'>⚠ No hay clientes en la base de datos</p>";
    }

} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Error de conexión: " . $e->getMessage() . "</p>";
}
?>